import argparse
import torch
import torch.nn.functional as F
from gcn_conv_copy import GCNConv

from citation import get_planetoid_dataset, random_planetoid_splits, run
from citation.train_eval import random_geom_splits, random_splits
from other_datasets import *
import torch_geometric.transforms as T
from gravnet_conv import GravNetConv 
from gcn_conv_ import GCNConv_1
import numpy as np 
import torch.nn as nn
from gcn_conv_copy_copy import GCNConv as GCN2
from scipy.linalg import fractional_matrix_power, inv

parser = argparse.ArgumentParser()
parser.add_argument('--dataset', type=str, default='cora')
parser.add_argument('--random_splits', type=bool, default=False)
parser.add_argument('--runs', type=int, default=1)
parser.add_argument('--epochs', type=int, default=1000)
parser.add_argument('--lr', type=float, default=0.01) 
parser.add_argument('--weight_decay', type=float, default=0.0005)
parser.add_argument('--early_stopping', type=int, default=200)
parser.add_argument('--hidden', type=int, default=32)
parser.add_argument('--dropout', type=float, default=0.5)
parser.add_argument('--normalize_features', type=bool, default=True)
parser.add_argument('--attack', type=str, default='no')
parser.add_argument('--ptb_rate', type=float, default=0.05)
args = parser.parse_args()


class Net(torch.nn.Module):
    def __init__(self, dataset):
        super(Net, self).__init__()
        # self.conv1 = GCNConv(dataset.num_features, args.hidden)
        self.conv2 = GCNConv(dataset.num_features, dataset.num_classes)
        self.convs=nn.ModuleList()
        for _ in range(64):
            self.convs.append(GCNConv(dataset.num_classes, dataset.num_classes))

    def reset_parameters(self):
        self.conv2.reset_parameters()
        for lin in self.convs:
            lin.reset_parameters()

    def forward(self, data):
        x, edge_index = data.x, data.edge_index
        # x = F.relu(self.conv1(x, edge_index))
        # x = F.dropout(x, p=args.dropout, training=self.training)


    
        x = self.conv2(x, edge_index)
        for i,con in enumerate(self.convs):
            x = con(x,edge_index)
        # num=x.shape[0]
        # a = np.random.binomial(n=1,p=0.5,size=(num,1))
        # a=torch.from_numpy(a).cuda(1)
        # x=x*a
        return F.log_softmax(x, dim=1)


if args.attack in ['random', 'meta']:
    dataset = AttackedDataset('', args.dataset, transforms=T.NormalizeFeatures(), args=args)
    permute_masks = None
    permute_masks = random_splits if args.random_splits else None
else:
    if args.dataset in ['cora', 'citeseer', 'pubmed']:
        dataset = get_planetoid_dataset(args.dataset, args.normalize_features)
        # permute_masks = random_planetoid_splits if args.random_splits else None
        permute_masks = random_geom_splits if args.random_splits else None
    else:
        import torch_geometric.transforms as T
        dataset = OtherDataset('', args.dataset, transform=T.NormalizeFeatures())
        permute_masks = random_splits if args.random_splits else None
        # if args.dataset != 'nell':
        #     permute_masks = random_planetoid_splits
        if args.dataset in ['chameleon', 'squirrel', 'film', 'cornell', 'texas', 'wisconsin']:
            permute_masks = random_geom_splits


# A=dataset.data.edge_index
# value=torch.ones(dataset.data.edge_index.shape[1],dtype=torch.float32)
# A = torch.sparse_coo_tensor(indices=A, values=value , size=[dataset.data.x.shape[0], dataset.data.x.shape[0]])


# def compute_ppr(a, alpha=0.2, self_loop=True):
#     # a = nx.convert_matrix.to_numpy_array(graph)
#     a = np.array(a.to_dense())
#     # if self_loop:
#     #     a = a + np.eye(a.shape[0])                                # A^ = A + I_n
#     d = np.diag(np.sum(a, 1))                                     # D^ = Sigma A^_ii
#     dinv = fractional_matrix_power(d, -0.5)                       # D^(-1/2)
#     at = np.matmul(np.matmul(dinv, a), dinv)                      # A~ = D^(-1/2) x A^ x D^(-1/2)
#     return alpha * inv((np.eye(a.shape[0]) - (1 - alpha) * at))

# A=compute_ppr(A)















import logging
LOG_FILENAME = 'log/gcn_noise.log'
logging.basicConfig(filename=LOG_FILENAME,level=logging.DEBUG)
logging.debug(f'Dataset {args.dataset}, hidden {args.hidden}, weight_decay {args.weight_decay}, lr {args.lr}, normalize_features {args.normalize_features}, ptb_rate {args.ptb_rate}')

run(dataset, Net(dataset), args.runs, args.epochs, args.lr, args.weight_decay,
    args.early_stopping, permute_masks, name=args.dataset, ptb_rate=args.ptb_rate)

